<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @bundles/CoreBundle/Twig/Extension/ThemesExtension.php */
class __TwigTemplate_067d8d4de6268bdc77ce6c8534cabaae extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<?php

declare(strict_types=1);

namespace Mautic\\CoreBundle\\Twig\\Extension;

use Mautic\\CoreBundle\\Helper\\CoreParametersHelper;
use Twig\\Extension\\AbstractExtension;
use Twig\\TwigFunction;

final class ThemesExtension extends AbstractExtension
{
    public function __construct(private CoreParametersHelper \$coreParametersHelper)
    {
    }

    public function getFunctions()
    {
        return [
            new TwigFunction('getTextOnBrandColor', [\$this, 'getTextOnBrandColor']),
            new TwigFunction('getTextOnBrandHelperColor', [\$this, 'getTextOnBrandHelperColor']),
            new TwigFunction('getBrandPrimaryColor', [\$this, 'getBrandPrimaryColor']),
        ];
    }

    public function getBrandPrimaryColor(): string
    {
        return \$this->coreParametersHelper->get('primary_brand_color', '000000');
    }

    public function getTextOnBrandColor(): string
    {
        \$primaryColor = \$this->getBrandPrimaryColor();

        \$r = hexdec(substr(\$primaryColor, 0, 2));
        \$g = hexdec(substr(\$primaryColor, 2, 2));
        \$b = hexdec(substr(\$primaryColor, 4, 2));

        // Calculate perceived brightness
        \$brightness = (\$r * 299 + \$g * 587 + \$b * 114) / 1000;

        // Determine text color based on brightness threshold
        return \$brightness > 125 ? '000000' : 'ffffff';
    }

    public function getTextOnBrandHelperColor(): string
    {
        return '000000' === \$this->getTextOnBrandColor() ? '6d6d6d' : 'b3b3b3';
    }
}
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@bundles/CoreBundle/Twig/Extension/ThemesExtension.php";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@bundles/CoreBundle/Twig/Extension/ThemesExtension.php", "/home/mauticapp/client/app/bundles/CoreBundle/Twig/Extension/ThemesExtension.php");
    }
}
