<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\BulkExports;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class ExportConfigurationOptions {
    /**
     * @param bool $enabled Whether files are automatically generated
     * @param string $webhookUrl URL targeted at export
     * @param string $webhookMethod Whether to GET or POST to the webhook url
     * @return UpdateExportConfigurationOptions Options builder
     */
    public static function update($enabled = Values::NONE, $webhookUrl = Values::NONE, $webhookMethod = Values::NONE) {
        return new UpdateExportConfigurationOptions($enabled, $webhookUrl, $webhookMethod);
    }
}

class UpdateExportConfigurationOptions extends Options {
    /**
     * @param bool $enabled Whether files are automatically generated
     * @param string $webhookUrl URL targeted at export
     * @param string $webhookMethod Whether to GET or POST to the webhook url
     */
    public function __construct($enabled = Values::NONE, $webhookUrl = Values::NONE, $webhookMethod = Values::NONE) {
        $this->options['enabled'] = $enabled;
        $this->options['webhookUrl'] = $webhookUrl;
        $this->options['webhookMethod'] = $webhookMethod;
    }

    /**
     * If true, Twilio will automatically generate every day's file when the day is over.
     *
     * @param bool $enabled Whether files are automatically generated
     * @return $this Fluent Builder
     */
    public function setEnabled($enabled) {
        $this->options['enabled'] = $enabled;
        return $this;
    }

    /**
     * Stores the URL destination for the method specified in webhook_method.
     *
     * @param string $webhookUrl URL targeted at export
     * @return $this Fluent Builder
     */
    public function setWebhookUrl($webhookUrl) {
        $this->options['webhookUrl'] = $webhookUrl;
        return $this;
    }

    /**
     * Sets whether Twilio should call a webhook URL when the automatic generation is complete, using GET or POST. The actual destination is set in the webhook_url
     *
     * @param string $webhookMethod Whether to GET or POST to the webhook url
     * @return $this Fluent Builder
     */
    public function setWebhookMethod($webhookMethod) {
        $this->options['webhookMethod'] = $webhookMethod;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.BulkExports.UpdateExportConfigurationOptions ' . \implode(' ', $options) . ']';
    }
}